//
//  Logger.m
//  Collections
//
//  Created by Jonathan Diehl on 02.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "Logger.h"


@implementation Logger

// logs the given dictionary in the form key -> object to the console
- (void)logDictionary:(NSDictionary *)dictionary;
{
	// iterate over the dictionary
	NSString *key;
	id object;
	for(key in dictionary) {
		object = [dictionary objectForKey:key];
		NSLog(@"%@ -> %@", key, object);
	}
}

// log and the objects in the array to the console
- (void)logArray:(NSArray *)array;
{
	// iterate over the array
	id object;
	for(object in array) {
		NSLog(@"%@", object);
	}
}

@end
